/**
(c) 2020 Contecon Software GmbH Author E. Schreiner

This is a simple example for calling an external program (e.G. Exiftool)
from PicApport.

Doku:
https://exiftool.org/

**/

import de.contecon.picapport.IPhotoMetaData;
import de.contecon.picapport.groovy.IAddonContext;
import de.contecon.picapport.groovy.IAddonExecutionContext;
import de.contecon.picapport.groovy.IAddonFileToProcess;
import de.contecon.picapport.groovy.PhotoFileProcessor;

class ExifToolSimpleInfo extends PhotoFileProcessor {

public Map init(IAddonContext addonContext) {
	addonContext.getLogger().logMessage(" Addon loaded. Autor: E. Schreiner (c)2020 Contecon Software GmbH" );
    
	def meta =  [
                version:'1.0.0', 
				functions: [
						   f1: [
							   name:       'Shows exiftool Metadata',
							   desc:       'See exiftool documentation on: https://exiftool.org/',
							   permission: 'pap:access:metadata',
                                 
                               parameter: [
                                          pathToExiftool: [
                                               type:       'text',
                                               label:      'Path to Exif-Tool',
                                               placeholder:'Server path to Exif-Tool',
                                               value:      addonContext.getConfigParAsString('pathToExiftool', ''),
                                               permission: 'pap:admin:addon:config'
                                           ],
                                           updateDefaults: [
                                               type:       'checkbox',
                                               label:      'Save current parameter values as defaults',
                                               value:      false,
                                               permission: 'pap:admin:addon:config'
                                           ],
                                      ],
                               ],           
						   ],
				i18n: [      
					  'de.f1.name':                 'Zeigt exiftool Metadaten',
					  'de.f1.desc':                 'Siehe exiftool Dokumentation auf: https://exiftool.org/',
                      'de.f1.apikey.label':         'Exif-Tool Pfad',
                      'de.f1.apikey.placeholder':   'Server-Pfad zum Exif-Tool',
                      'de.f1.updateDefaults.label': 'Aktuelle Parameter als Vorgabe speichern',
					  ],						
				]
	}

  /**
   * Save current parameter values from GUI in config.json in addon directory
   *
   * author Eric 22.07.2020
   * @param addonContext
   * @param aec
   */
  private void handleDefaultParameterUpdate(IAddonContext addonContext, IAddonExecutionContext aec) {
    addonContext.putConfigPar("pathToExiftool",       aec.pathToExiftool);
    addonContext.updateConfigFile();
    }
  
 
/*
 * This method is called one Time befor processing of each photo starts
 * use IAddonExecutionContext aec as a map to store values over the livetime of this procedure 
 */
public void start(IAddonContext addonContext, IAddonExecutionContext aec) {
    addonContext.getLogger().logMessage(" Addon loaded. Autor: E. Schreiner (c)2020 Contecon Software GmbH" );
    
    aec.setShowResults(true);                   // Indicate that this procedure shows a result to the user
    
    def titleMap;
    
    if(aec.updateDefaults) {
      handleDefaultParameterUpdate(addonContext, aec);
      titleMap =["Run-mode":addonContext.i18n("New parameter settings saved.",  ["de":"Neue Parametervorgaben gespeichert."])
                ];
      aec.signalTermination();
      } else {
      def result = execute(addonContext, [aec.pathToExiftool, "-ver"]);
      titleMap=["Exiftool Version":result];
      }
    
    // report exiftool version in header
	aec.getPhotoFileProcessorResultGenerator().addGroupData("PicApport exiftool Add-on", titleMap);
    }
  
    
/**
 * This method is called for each selected photo
 */
public void processPhotoFile(IAddonContext addonContext, IAddonExecutionContext aec, IAddonFileToProcess fileToProcess) {
    def originalFile = fileToProcess.getOriginalFile();
    def baseAttrMap=[:] as LinkedHashMap; // Content of this map will always be visible below the image (Filename etc)
        baseAttrMap['Name']         = originalFile.getName();
        baseAttrMap['Path']         = originalFile.getParent();
        baseAttrMap['Length']       = originalFile.length();
        baseAttrMap['Last Modified']= new Date(originalFile.lastModified());
    
    def result = execute(addonContext, [aec.pathToExiftool, fileToProcess.getFileWithJpgImage().getCanonicalPath()]);
        
    // report result    
    aec.getPhotoFileProcessorResultGenerator().addGroupData("PicApport exiftool Addon", baseAttrMap);
    aec.getPhotoFileProcessorResultGenerator().addGroupData("PicApport exiftool data",  result);
    }
	
    
private String execute(IAddonContext addonContext, List command) {
   def out = new StringBuffer();
   def err = new StringBuffer();
   addonContext.getLogger().logDebugMessage(" execute: "+command);
   def process = command.execute();
       process.waitForProcessOutput(out,err); // We strongly recommend to execute childprocesses the way we do it here
                                              // to avoid blocking of the child process output.
   return out.toString();  		
   }
   
   
}