import de.contecon.picapport.TagList

/**
(c) 2020 Contecon Software GmbH Author E. Schreiner

Add Imagga related Fields to PicApport Database.
Requires Imagga.groovy to load metadata provided by Imagga in XMP data of Photo. 

Doku:
https://imagga.com/


**/

import de.contecon.imageutils.IccImageMetaData;

import de.contecon.picapport.IPhotoMetaDataFilter;
import de.contecon.picapport.groovy.IAddonContext;
import de.contecon.picapport.groovy.PhotoFieldProvider;

import org.json.JSONArray;
import org.json.JSONObject;

class TagYourPhotosFields extends PhotoFieldProvider {

def ADDON_TYPE_ID = "imagga.com";
  
private final static String FIELD_NAME_IMAGGA          ="Imagga";  
private final static String FIELD_NAME_IMAGGA_TAGS     ="ImaggaTags";

  
public Map init(IAddonContext addonContext) {
	addonContext.getLogger().logMessage(" Addon loaded. Autor: E. Schreiner (c)2020 Contecon Software GmbH" );

	def meta =  [
                version:'1.0.0',
				fields: [
						(FIELD_NAME_IMAGGA): [ // Fulltext of all Fields returned by Imagga
							     type:                  PhotoFieldProvider.DATA_TYPE_STRING,
								 addToGlobalFulltext:   true,
							     indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
	                             ],
                        (FIELD_NAME_IMAGGA_TAGS): [  // "tags" returned from Imagga
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalKeywords:   true,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_HIERARCHICAL,
                                 addToReport:           true,
                                 dataId:                ADDON_TYPE_ID, // Very important! Tags can only be removed with PicApports WebGUI if
                                                                       // addToGlobalKeywords=true, and dataId is defined
                                 ]
						]
                ]						
	}
 

/**
 * Optional Method. Can be used to support tag removal from Keywords. addonData is always a String representation
 * and must be converted to JSON an back after it has been changed. The Method should return null if nothing has 
 * been removed.   
 */
public String removeKeywords(final String addonData,  final List<String> tags) {
    def tagsHaveBeenRemoved = false
    JSONObject imaggaJSON = new JSONObject(addonData); // Get metadata created by TagYourPhotos.groovy (provided as a JSON String)
    
    tagsHaveBeenRemoved=removeKeywordsFromJSON(imaggaJSON, tags);
    
    return tagsHaveBeenRemoved ? imaggaJSON.toString() : null;  
    }

      
public void setFieldValues(IAddonContext addonContext, IccImageMetaData metaDataFile, IPhotoMetaDataFilter metadataDatabase) {
    // Get metadata created by TagYourPhotos.groovy
    JSONObject imaggaJSON = metaDataFile.getPicApportXmpMetaDataAsJSON(ADDON_TYPE_ID);
    if(null != imaggaJSON) {
      def imaggaFulltext="";
       
      imaggaFulltext = append(imaggaFulltext, fieldfromArray(metadataDatabase, imaggaJSON, "tags",      "tag",      FIELD_NAME_IMAGGA_TAGS,      "; " ),", ");
      
      
      metadataDatabase.setAddonFieldValue(FIELD_NAME_IMAGGA, imaggaFulltext.trim());
      }
    }

private String fieldfromArray(IPhotoMetaDataFilter metadataDatabase, JSONObject imaggaJSON, String nameArray, String fieldNameInArray, String databaseFieldName, String separator) {
  String fieldValue="";
   if(imaggaJSON.has(nameArray)) {
      JSONArray arrayJSON=imaggaJSON.getJSONArray(nameArray);
      for(int i=0; i<arrayJSON.length(); i++) {
         fieldValue = append(fieldValue, arrayJSON.getJSONObject(i).getString(fieldNameInArray), separator);
         }
      metadataDatabase.setAddonFieldValue(databaseFieldName, fieldValue.trim());
      }
   return fieldValue;      
   }       
    
 private String append(String s1, String s2, String separator) {
   if(null != s2 && s2.trim().length() > 0) {
     if(s1.trim().length() > 0) {
       s1 += (separator + s2.trim());
       } else {
       s1 = s2.trim();
       }
     }  
   return s1;
   }
    
    
 private boolean removeKeywordsFromJSON(final JSONObject imaggaJSON, final List<String> tags) {
   def tagsHaveBeenremoved=false;
   
   if(imaggaJSON.has("tags")) {
     def tagArray = imaggaJSON.getJSONArray("tags");
     for(int i=tagArray.length()-1; i>=0; i--) {
        def tag=tagArray.getJSONObject(i).getString("tag").trim();
        for(String tagToremove: tags) {
           if(tag.equalsIgnoreCase(tagToremove)) {
             tagArray.remove(i);
             tagsHaveBeenremoved=true;
             break;  
             }
           } 
        } 
     }
   return tagsHaveBeenremoved;
   }
          
}
