/**
(c) 2020 Contecon Software GmbH Author E. Schreiner

Add OSM related Fields to PicApport Database. 
Requires OSMGeoReverseEncoder.groovy to load metadata provided by OSM in XMP data of Photo. 

Doku:
https://nominatim.org/release-docs/develop/api/Reverse/


**/

import de.contecon.imageutils.IccImageMetaData;

import de.contecon.picapport.IPhotoMetaDataFilter;
import de.contecon.picapport.groovy.IAddonContext;
import de.contecon.picapport.groovy.PhotoFieldProvider;

import org.json.JSONObject;

class OSMFields extends PhotoFieldProvider {

private final static String FIELD_NAME_OSM         = "osm";  
private final static String FIELD_NAME_OSM_COUNTRY = "osmCountry";
private final static String FIELD_NAME_OSM_STATE   = "osmState";
private final static String FIELD_NAME_OSM_POSTCODE= "osmPostcode";
private final static String FIELD_NAME_OSM_CITY=     "osmCity";
private final static String FIELD_NAME_OSM_ROAD=     "osmRoad";
  
  
public Map init(IAddonContext addonContext) {
	addonContext.getLogger().logMessage(" Addon loaded Autor: E. Schreiner (c)2020 Contecon Software GmbH" );

	def meta =  [
                version:'2.0.0',
				fields: [
						(FIELD_NAME_OSM): [ // "display_name" returned from OSM
							     type:                  PhotoFieldProvider.DATA_TYPE_STRING,
								 addToGlobalFulltext:   true,
							     indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
	                             ],
                        (FIELD_NAME_OSM_COUNTRY): [ // "country" returned from OSM
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalFulltext:   false,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
                                 ],
                        (FIELD_NAME_OSM_STATE): [ // "state" returned from OSM
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalFulltext:   false,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
                                 ],
                        (FIELD_NAME_OSM_POSTCODE): [ // "postcode" returned from OSM
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalFulltext:   false,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_ID,
                                 addToReport:           true,
                                 ],
                        (FIELD_NAME_OSM_CITY): [ // "city", "town", "village" returned from OSM
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalFulltext:   false,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
                                 ],
                        (FIELD_NAME_OSM_ROAD): [ // "road" returned from OSM
							     type:                  PhotoFieldProvider.DATA_TYPE_STRING,
								 addToGlobalFulltext:   false,
							     indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
	                             ]								 
						]
                ]						
	}
 
public void setFieldValues(IAddonContext addonContext, IccImageMetaData metaDataFile, IPhotoMetaDataFilter metadataDatabase) {
    // Get metadata created by OSMGeoReverseEncoder.groovy
    JSONObject osmJSON = metaDataFile.getPicApportXmpMetaDataAsJSON("osm.org");
    if(null != osmJSON) {
      setOptionalFieldValue(metadataDatabase, osmJSON, FIELD_NAME_OSM, "display_name");
      
      if(osmJSON.has("address")) {
        JSONObject addressJSON=osmJSON.getJSONObject("address");
        
        setOptionalFieldValue(metadataDatabase, addressJSON, FIELD_NAME_OSM_COUNTRY, "country");
        setOptionalFieldValue(metadataDatabase, addressJSON, FIELD_NAME_OSM_STATE, "state");
        setOptionalFieldValue(metadataDatabase, addressJSON, FIELD_NAME_OSM_POSTCODE, "postcode");
        
        setOptionalFieldValue(metadataDatabase, addressJSON, FIELD_NAME_OSM_CITY, "village");
        setOptionalFieldValue(metadataDatabase, addressJSON, FIELD_NAME_OSM_CITY, "town");   // Overwrites village if exits
        setOptionalFieldValue(metadataDatabase, addressJSON, FIELD_NAME_OSM_CITY, "city");   // Overwrites town or village if exits
        
        setOptionalFieldValue(metadataDatabase, addressJSON, FIELD_NAME_OSM_ROAD, "road");
        }
      }
    }

 private void setOptionalFieldValue(IPhotoMetaDataFilter metadataDatabase, JSONObject json, String fieldNameDatabase, String fieldNameJson) {
   if(json.has(fieldNameJson)) {
     metadataDatabase.setAddonFieldValue(fieldNameDatabase, json.getString(fieldNameJson));
     }
   }       
        
		
}
