import de.contecon.picapport.TagList

/**
(c) 2020 Contecon Software GmbH Author E. Schreiner

Add TagYourPhotos related Fields to PicApport Database.
Requires TagYourPhotos.groovy to load metadata provided by TYP in XMP data of Photo. 

Doku:
https://www.tagyour.photos/


**/

import de.contecon.imageutils.IccImageMetaData;

import de.contecon.picapport.IPhotoMetaDataFilter;
import de.contecon.picapport.groovy.IAddonContext;
import de.contecon.picapport.groovy.PhotoFieldProvider;

import org.json.JSONArray;
import org.json.JSONObject;

class TagYourPhotosFields extends PhotoFieldProvider {

def ADDON_TYPE_ID = "tagyourphotos.de";
  
private final static String FIELD_NAME_TYP          ="TagYourPhotos";  
private final static String FIELD_NAME_TYP_TAGS     ="typTags";
private final static String FIELD_NAME_TYP_LANDMARKS="typLandmarks";
private final static String FIELD_NAME_TYP_COUNTRY  ="typCountry";
private final static String FIELD_NAME_TYP_STATE    ="typState";
private final static String FIELD_NAME_TYP_CITY=     "typCity";
private final static String FIELD_NAME_TYP_DISTRICT= "typDistrict";
  
public Map init(IAddonContext addonContext) {
	addonContext.getLogger().logMessage(" Addon loaded. Autor: E. Schreiner (c)2020 Contecon Software GmbH" );

	def meta =  [
                version:'1.0.0',
				fields: [
						(FIELD_NAME_TYP): [ // Fulltext of all Fields returned by TYP
							     type:                  PhotoFieldProvider.DATA_TYPE_STRING,
								 addToGlobalFulltext:   true,
							     indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
	                             ],
                        (FIELD_NAME_TYP_TAGS): [  // "tags" returned from TYP
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalKeywords:   true,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_HIERARCHICAL,
                                 addToReport:           true,
                                 dataId:                ADDON_TYPE_ID, // Very important! Tags can only be removed with PicApports WebGUI if
                                                                       // addToGlobalKeywords=true, and dataId is defined
                                 ],
                        (FIELD_NAME_TYP_LANDMARKS): [ // "landmarks" returned from TYP
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalFulltext:   false,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
                                 ],
                        (FIELD_NAME_TYP_COUNTRY): [ // "country" returned from TYP
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalFulltext:   false,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
                                 ],
                        (FIELD_NAME_TYP_STATE): [ // "state" returned from TYP
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalFulltext:   false,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
                                 ],
                        (FIELD_NAME_TYP_CITY): [ // "city" returned from TYP
                                 type:                  PhotoFieldProvider.DATA_TYPE_STRING,
                                 addToGlobalFulltext:   false,
                                 indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
                                 ],
                        (FIELD_NAME_TYP_DISTRICT): [ // "district" returned from TYP
							     type:                  PhotoFieldProvider.DATA_TYPE_STRING,
								 addToGlobalFulltext:   false,
							     indexType:             PhotoFieldProvider.INDEX_TYPE_FULLTEXT,
                                 addToReport:           true,
	                             ]								 
						]
                ]						
	}
 

/**
 * Optional Method. Can be used to support tag removal from Keywords. addonData is always a String representation
 * and must be converted to JSON an back after it has been changed. The Method should return null if nothing has 
 * been removed.   
 */
public String removeKeywords(final String addonData,  final List<String> tags) {
    def tagsHaveBeenRemoved = false
    JSONObject typJSON = new JSONObject(addonData); // Get metadata created by TagYourPhotos.groovy (provided as a JSON String)
    
    tagsHaveBeenRemoved=removeKeywordsFromJSON(typJSON, tags);
    
    return tagsHaveBeenRemoved ? typJSON.toString() : null;  
    }

      
public void setFieldValues(IAddonContext addonContext, IccImageMetaData metaDataFile, IPhotoMetaDataFilter metadataDatabase) {
    // Get metadata created by TagYourPhotos.groovy
    JSONObject typJSON = metaDataFile.getPicApportXmpMetaDataAsJSON(ADDON_TYPE_ID);
    if(null != typJSON) {
      def typFulltext="";
       
      typFulltext = append(typFulltext, fieldfromArray(metadataDatabase, typJSON, "tags",      "tag",      FIELD_NAME_TYP_TAGS,      "; " ),", ");
      typFulltext = append(typFulltext, fieldfromArray(metadataDatabase, typJSON, "landmarks", "landmark", FIELD_NAME_TYP_LANDMARKS, ", " ),", ");
        
      typFulltext = append(typFulltext, setOptionalFieldValue(metadataDatabase, typJSON, FIELD_NAME_TYP_COUNTRY, "country"), ", ");
      typFulltext = append(typFulltext, setOptionalFieldValue(metadataDatabase, typJSON, FIELD_NAME_TYP_STATE,   "state"), ", ");
      typFulltext = append(typFulltext, setOptionalFieldValue(metadataDatabase, typJSON, FIELD_NAME_TYP_CITY,    "city"), ", "); 
      typFulltext = append(typFulltext, setOptionalFieldValue(metadataDatabase, typJSON, FIELD_NAME_TYP_DISTRICT,"district"), ", ");
      
      metadataDatabase.setAddonFieldValue(FIELD_NAME_TYP, typFulltext.trim());
      }
    }

private String fieldfromArray(IPhotoMetaDataFilter metadataDatabase, JSONObject typJSON, String nameArray, String fieldNameInArray, String databaseFieldName, String separator) {
  String fieldValue="";
   if(typJSON.has(nameArray)) {
      JSONArray arrayJSON=typJSON.getJSONArray(nameArray);
      for(int i=0; i<arrayJSON.length(); i++) {
         fieldValue = append(fieldValue, arrayJSON.getJSONObject(i).getString(fieldNameInArray), separator);
         }
      metadataDatabase.setAddonFieldValue(databaseFieldName, fieldValue.trim());
      }
   return fieldValue;      
   }       
    
 private String append(String s1, String s2, String separator) {
   if(null != s2 && s2.trim().length() > 0) {
     if(s1.trim().length() > 0) {
       s1 += (separator + s2.trim());
       } else {
       s1 = s2.trim();
       }
     }  
   return s1;
   }
    
 private String setOptionalFieldValue(IPhotoMetaDataFilter metadataDatabase, JSONObject json, String fieldNameDatabase, String fieldNameJson) {
   String value="";
   if(json.has(fieldNameJson)) {
     value = json.getString(fieldNameJson);
     metadataDatabase.setAddonFieldValue(fieldNameDatabase, value);
     }
   return value;  
   }
   
 private boolean removeKeywordsFromJSON(final JSONObject typJSON, final List<String> tags) {
   def tagsHaveBeenremoved=false;
   
   if(typJSON.has("tags")) {
     def tagArray = typJSON.getJSONArray("tags");
     for(int i=tagArray.length()-1; i>=0; i--) {
        def tag=tagArray.getJSONObject(i).getString("tag").trim();
        for(String tagToremove: tags) {
           if(tag.equalsIgnoreCase(tagToremove)) {
             tagArray.remove(i);
             tagsHaveBeenremoved=true;
             break;  
             }
           } 
        } 
     }
   return tagsHaveBeenremoved;
   }
          
}
